<?php get_header(); ?>
<div class="container">
    <div id="artigos">
        <div class="row">
            <div class="col-lg-2">
                <?php echo file_get_contents('https://laldhome.com.br/super_ajax/menu'); ?>
            </div>
            <div class="col-lg-10">
                <header class="headinterna">
                    <h1 class="titulo">Blog da Lald</h1>
                    <h2 class="subtitulo">
                        <span>Leia as últimas novidades da Lald Home!</span>
                    </h2>
                    <img class="bg" src="https://assets.lands.net.br/lald/imagens/bg-headinterna.png">
                </header>
                <div class="row">
                    <div class="col-lg-8">
                        <div class="lista">
                            <div class="row">
                                <?php if (have_posts()) : ?>
                                    <?php while (have_posts()) : the_post(); ?>
                                        <div class="col-lg-6">
                                            <div class="item">
                                                <div class="data"><a href="<?php the_permalink() ?>"><?php the_time('j \d\e F \d\e Y') ?></a></div>
                                                <div class="autor"><a title="Leia todas as postagens de <?php the_author() ?>" href="<?php echo get_author_posts_url(get_the_author_meta('id')); ?>">Por <span><?php the_author() ?></span></a></div> 
                                                <!--  Postado  em - <?php comments_popup_link('Sem Comentários', '1 Comentário', '% Comentários', 'comments-link', ''); ?> <?php edit_post_link('(Editar)'); ?> -->
                                                <h2 class="titblog">
                                                    <a href="<?php the_permalink() ?>">
                                                        <?php if (strlen(get_the_title()) < 60): ?>
                                                            <?php the_title(); ?>
                                                        <?php else: ?>
                                                            <?php echo mb_substr(trim(strip_tags(html_entity_decode(get_the_title()))), 0, 60,  'utf-8'); ?>...
                                                        <?php endif; ?>
                                                    </a>
                                                </h2>
                                                <div class="imagemblog">
                                                    <a href="<?php the_permalink() ?>">
                                                        <?php if (has_post_thumbnail()): ?>
                                                            <?php the_post_thumbnail(); ?>
                                                        <?php elseif (!empty(catch_first_image())): ?>
                                                            <img src="<?= catch_first_image() ?>" />
                                                        <?php else: ?>
                                                            <img src="<?= get_template_directory_uri(); ?>/assets/imagens/indisponivel.png" />
                                                        <?php endif; ?>
                                                    </a>
                                                </div>
                                                <div class="lista-categoria"><span>Categorias</span> <?php the_category( ', ' ); ?></div> 
                                                <div class="descricao">
                                                    <a href="<?php the_permalink() ?>">
                                                        <?php $content = htmlspecialchars_decode(strip_tags($post->post_content)); ?>
                                                        <?= trim(substr($content, 0, 150)); ?><?php if (strlen($content) >= 150): ?>...<?php endif; ?>
                                                    </a>
                                                </div>
                                                <div class="botao"><a href="<?php the_permalink() ?>">Continue Lendo</a></div>
                                            </div>	
                                        </div>		
                                    <?php endwhile ?>
                                    <div class="col-sm-12">
                                        <div class="navegacao">
                                            <?php numeric_posts_nav(); ?>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="recentes"><?php next_posts_link('&laquo; Artigos Anteriores') ?></div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="anteriores"><?php previous_posts_link('Artigos Recentes &raquo;') ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>  
                                <?php else: ?>
                                    <div class="col-lg-12">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/imagens/404.png" class="img-fluid" alt="Erro 404">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <?php get_sidebar(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>